/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_ibarrier.c,v 1.11 2005/06/29 00:23:16 eugene Exp $";

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

/*
mx_return_t
mx_post_barrier(mx_endpoint_t endpoint,
		mx_endpoint_addr_t *addr_list,
		uint32_t addr_count,
		uint64_t match_data,
		void *callback_arg,
		mx_request_t *handle)
*/
mx_return_t
mx_ibarrier(mx_endpoint_t endpoint,
            mx_endpoint_addr_t *addr_list,
            uint32_t addr_count,
	    uint64_t match_info,
            void *context,
            mx_request_t *request)
{
  struct mx_endpoint *pp = endpoint;
  mx_return_t status = MX_SUCCESS;
  static mx_segment_t segment;
  static mx_segment_t segment2;
  static mx_segment_t segment3;
  static char buf[16];
  static char buf2[16];
  static char buf3[16];
  mx_request_t junk;
  struct mx_lib_barrier *barrier;
  struct mx_post *post;
  int matched;
  struct mx_post *bcast_post;
  struct mx_barrier_callback_tuple *tuple;

  if (memcmp (pp->my_address.stuff, addr_list[0].stuff,
	      sizeof (pp->my_address.stuff)) == 0) {
    /* I'm the barrier. */
    segment3.segment_ptr = buf3;
    segment3.segment_length = 16;
    bcast_post = mx_create_bcast_post (pp, &segment3, 1, addr_list,
				       addr_count, 0,
				       match_info,
				       context,
				       MX_SR_TYPE_BARRIER_ACK);
    if (bcast_post == NULL) {
      /* XXX */
      exit (1);
    }

    tuple = malloc(sizeof (*tuple));
    if (tuple == NULL) {
      /* XXX */
      exit(1);
    }

    tuple->callback = mx_barrier_callback;
    tuple->post = bcast_post;
		      
    /* get a post record */
    post = mx_new_post(pp, MX_POST_TYPE_BARRIER, tuple);
    barrier = &(post->ts.barrier);
    
    /* fill in barrier fields */
    barrier->match_info = match_info;
    barrier->type = MX_SR_TYPE_BARRIER;
    barrier->nsock = addr_count;

    /* XXX */
    /* try to match with queue of unexpected messages */
    pthread_mutex_lock(&Mx_rx_lock);
    matched = mx_match_queued_barrier(post, MX_SR_TYPE_BARRIER);

    /* if no match, put this on endpoints active receive list at the end */
    if (!matched) {
      MX_LIST_INSERT(&pp->barrier_list, post);
      MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("barrier on 0x%08x%08x now pending\n",
		MX_U32(match_info), MX_L32(match_info)));
    }
    pthread_mutex_unlock(&Mx_rx_lock);

    /* return this handle */
    if (request != NULL) {
      *request = (mx_request_t)bcast_post;
    }
  }
  else {
    sprintf(buf, "%u", addr_count);
    segment.segment_ptr = buf;
    segment.segment_length = strlen(buf)+1;
    MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("addr_count = %u, buf = %s\n", addr_count, buf));

    status = mx_isend_with_type(endpoint, &segment, 1,
                                addr_list[0],
                                match_info, NULL, &junk,
                                MX_SR_TYPE_BARRIER,
                                0, 0, 0);
    if (status != MX_SUCCESS){
      return status;
    }

    segment2.segment_ptr = buf2;
    segment2.segment_length = 16;
    status = mx_ibcast_with_type(endpoint, &segment2, 1, addr_list,
                                 addr_count, 0, match_info, 
                                 context, request,
                                 MX_SR_TYPE_BARRIER_ACK);
    if (status != MX_SUCCESS){
      return status;
    }
  }

  return status;
}

void
mx_barrier_callback (mx_endpoint_t endpoint,
                    struct mx_post *post)
{
  struct mx_endpoint *pp = endpoint;
  pthread_mutex_lock(&Mx_tx_lock);
  MX_LIST_INSERT(&pp->bcast_list, post);
  pthread_cond_signal(&Mx_send_cond);
  pthread_mutex_unlock(&Mx_tx_lock);
}
